####设置路径，随机化种子
setwd("/disk213/gujm/R/robustness/falsepostive")
for (select in c(2425,2460,2479,2484,2511,2706,2757,2787,2790,2842)) {
  library('MoBPS')
  library('RandomFieldsUtils')
  library('miraculix')
  library('MoBPSmaps')
  plink<-'/disk213/gujm/software/plink'
  bcftools<-'/disk193/ShareData/2_software/bcftools-1.12/bcftools'
  vcftools<-'/disk193/ShareData/2_software/vcftools_0.1.13/bin/vcftools'
  set.seed(select)
  ####创建历史群体
  population <- creating.diploid(nsnp=15000, nindi=200,
                                 chr.nr=18, chromosome.length=2,
                                 n.additive=c(100,500),#只考虑加性效应
                                 share.genotyped = 0,
                                 name.cohort="Founder",
                                 var.target = c(1,1),
                                 trait.name = c("ADG", "IMF"))
  population <- breeding.diploid(population, heritability=c(0.35,0.24),
                                 phenotyping="all")
  get.cohorts(population)
  
  ####构建原始理想个体
  ####IMF对应QTL
  QTL_effects <- get.qtl.effects(population)
  QTL_effects <- QTL_effects[[1]][[2]]
  for (i in 1:nrow(QTL_effects)) {
    if(QTL_effects[i,3]>=0){
      QTL_effects[i,4]<-0
    }else{
      QTL_effects[i,4]<-2
    }
  }
  II1<-QTL_effects[,c(1,2,3,4)]
  II1[,1]<-paste0('Chr',II1[,2],'SNP',II1[,1])
  II1<-II1[,c(1,4,3)]
  II1 <- cbind(II1,0)
  for (i in 1:nrow(II1)) {
    if(II1[i,2]==0){
      II1[i,4]<-"A"
    }else{
      II1[i,4]<-"C"
    }
  }
  effect_IMF <- abs(as.numeric(II1[,3]))
  II1[,3] <- effect_IMF
  p <- order(effect_IMF)
  II1 <- II1[p,]
  snp_IMF <- II1[,1]
  recodeIMF <- II1[,c(1,4)]
  write.table(x=snp_IMF,file = "snp_IMF.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recodeIMF,file = "recodeIMF.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  ####ADG对应QTL
  QTL_effects <- get.qtl.effects(population)
  QTL_effects <- QTL_effects[[1]][[1]]
  for (i in 1:nrow(QTL_effects)) {
    if(QTL_effects[i,3]>=0){
      QTL_effects[i,4]<-0
    }else{
      QTL_effects[i,4]<-2
    }
  }
  II2<-QTL_effects[,c(1,2,3,4)]
  II2[,1]<-paste0('Chr',II2[,2],'SNP',II2[,1])
  II2<-II2[,c(1,4,3)]
  II2 <- cbind(II2,0)
  for (i in 1:nrow(II2)) {
    if(II2[i,2]==0){
      II2[i,4]<-"A"
    }else{
      II2[i,4]<-"C"
    }
  }
  effect_ADG <- abs(as.numeric(II2[,3]))
  II2[,3] <- effect_ADG
  p <- order(effect_ADG)
  II2 <- II2[p,]
  snp_ADG <- II2[,1]
  recodeADG <- II2[,c(1,4)]
  write.table(x=snp_ADG,file = "snp_ADG.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recodeADG,file = "recodeADG.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  II <- rbind(II2,II1)
  snp_ideal <- II[,1]
  recode <- II[,c(1,4)]
  write.table(x=snp_ideal,file = "snp_ideal.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recode,file = "recode.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=snp_ideal,file = "snp.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recode,file = "recodeIDEAL.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  effect_ideal <- abs(as.numeric(II[,3]))
  effect_ideal <- t(rbind(II[,1],effect_ideal))
  ####Founder群体QTL检验
  get.vcf(population,'Founder',chromosomen="all",gen = 1)
  system(paste0(bcftools,' view -v snps Founder.vcf -Oz -o Founder.filter.vcf.gz'))
  system(paste0(plink,' --vcf Founder.filter.vcf.gz --recode --out Founder'))
  system(paste0(plink,' --vcf Founder.filter.vcf.gz --make-bed --out Founder'))
  ####与原始理想个体进行比对
  system(paste0(plink," --bfile Founder --noweb --extract snp_ideal.txt --recode --make-bed --out snp_Founder"))
  system(paste0(plink," --bfile snp_Founder --recode A --recode-allele recode.txt --out recodeFounder"))
  raw <- read.table(file="recodeFounder.raw")
  raw_index <- t(raw[1,-c(1:6)])
  raw_index <- as.data.frame(as.character(unlist(strsplit(raw_index, split = "_"))))
  raw_index <- raw_index[seq(1,nrow(raw_index),2),]
  effect <- match(raw_index,effect_ideal)
  effect <- effect_ideal[effect,2]
  effect <- matrix(as.numeric(as.matrix(effect)),600,1)
  
  #################################################################################################################################
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  ##          ######################################################################################################             ##
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  #################################################################################################################################
  
  ####针对ADG性状选育10个世代
  ####与ADG理想模块进行比对
  system(paste0(plink," --bfile Founder --noweb --extract snp_ADG.txt --recode --make-bed --out snp_Founder"))
  system(paste0(plink," --bfile snp_Founder --recode A --recode-allele recodeADG.txt --out recodeFounder"))
  raw <- read.table(file="recodeFounder.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  bv_Founder <- get.bv(population,gen = 1)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "Founder_M",
                                 selection.f.cohorts = "Founder_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "FounderADG_1",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=2)
  get.cohorts(population)
  ####一代修改育种值
  get.vcf(population,'pop_Founder1',chromosomen="all",gen = 2)
  system(paste0(bcftools,' view -v snps pop_Founder1.vcf -Oz -o pop_Founder1.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_Founder1.filter.vcf.gz --recode --out pop_Founder1'))
  system(paste0(plink,' --vcf pop_Founder1.filter.vcf.gz --make-bed --out pop_Founder1'))
  ####与ADG理想模块进行比对
  system(paste0(plink," --bfile pop_Founder1 --noweb --extract snp_ADG.txt --recode --make-bed --out snp_Founder1"))
  system(paste0(plink," --bfile snp_Founder1 --recode A --recode-allele recodeADG.txt --out recodeFounder1"))
  raw <- read.table(file="recodeFounder1.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  bv_Founder <- get.bv(population,gen = 2)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  
  for(index in 1:9){
    population <- breeding.diploid(population,breeding.size = c(100,100),
                                   selection.size=c(5,20),
                                   selection.m.cohorts = paste0("FounderADG_",index,"_M"),
                                   selection.f.cohorts = paste0("FounderADG_",index,"_F"),                                 
                                   selection.criteria='bve',
                                   name.cohort = paste0("FounderADG_",index+1),
                                   phenotyping="all",
                                   miraculix.cores=4)
    cohort <- paste0("pop_FounderADG",index+1)
    cohort1 <- paste0("snp_FounderADG",index+1)
    cohort2 <- paste0("recodeADG",index+1)
    get.vcf(population,cohort,gen = index+2)
    system(paste0(bcftools,' view -v snps ',paste0(cohort,".vcf")," -Oz -o ",paste0(cohort,".filter.vcf.gz")))
    system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --recode --out ',cohort))
    system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --make-bed --out ',cohort))
    ####与ADG理想模块进行比对
    system(paste0(plink," --bfile ",cohort,' --noweb --extract snp_ADG.txt --recode --make-bed --out ',cohort1))
    system(paste0(plink," --bfile ",cohort1,' --recode A --recode-allele recodeADG.txt --out ',cohort2))
    raw <- read.table(file = paste0(cohort2,".raw"))
    raw <- raw[-1,-c(1:6)]
    c <- length(raw[1,])
    r <- length(raw[,1])/2
    raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
    raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
    raw3 <- order(-raw2)
    raw3 <- raw3[1:5]
    raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
    raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
    raw6 <- order(-raw5)
    raw6 <- raw6[1:20] + 100
    bv_Founder <- get.bv(population,gen = index+2)
    bv_Founder[c(1,2),c(raw3,raw6)] <- 120
    bv_Founder <- t(bv_Founder)
    write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
    bv_Founder_R <- read.csv("bv_Founder.csv")
    population <- insert.bve(population,bv_Founder_R,type = "bve")
  }
  
  ####针对IMF性状选育10个世代
  ####与IMF理想模块进行比对
  system(paste0(plink," --bfile Founder --noweb --extract snp_IMF.txt --recode --make-bed --out snp_FounderIMF"))
  system(paste0(plink," --bfile snp_FounderIMF --recode A --recode-allele recodeIMF.txt --out recodeFounderIMF"))
  raw <- read.table(file="recodeFounderIMF.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  bv_Founder <- get.bv(population,gen = 1)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "Founder_M",
                                 selection.f.cohorts = "Founder_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "FounderIMF_1",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=12)
  get.cohorts(population)
  
  ####一代育种值修改
  get.vcf(population,'pop_FounderIMF1',chromosomen="all",gen = 12)
  system(paste0(bcftools,' view -v snps pop_FounderIMF1.vcf -Oz -o pop_FounderIMF1.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_FounderIMF1.filter.vcf.gz --recode --out pop_FounderIMF1'))
  system(paste0(plink,' --vcf pop_FounderIMF1.filter.vcf.gz --make-bed --out pop_FounderIMF1'))
  system(paste0(plink," --bfile pop_FounderIMF1 --noweb --extract snp_IMF.txt --recode --make-bed --out snp_FounderIMF1"))
  system(paste0(plink," --bfile snp_FounderIMF1 --recode A --recode-allele recodeIMF.txt --out recodeFounderIMF1"))
  raw <- read.table(file="recodeFounderIMF1.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  bv_Founder <- get.bv(population,gen = 12)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  
  for(index in 1:9){
    population <- breeding.diploid(population,breeding.size = c(100,100),
                                   selection.size=c(5,20),
                                   selection.m.cohorts = paste0("FounderIMF_",index,"_M"),
                                   selection.f.cohorts = paste0("FounderIMF_",index,"_F"),                                 
                                   selection.criteria='bve',
                                   name.cohort = paste0("FounderIMF_",index+1),
                                   phenotyping="all",
                                   miraculix.cores=4)
    cohort <- paste0("pop_FounderIMF",index+1)
    cohort1 <- paste0("snp_FounderIMF",index+1)
    cohort2 <- paste0("recodeIMF",index+1)
    get.vcf(population,cohort,gen = index+12)
    system(paste0(bcftools,' view -v snps ',paste0(cohort,".vcf")," -Oz -o ",paste0(cohort,".filter.vcf.gz")))
    system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --recode --out ',cohort))
    system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --make-bed --out ',cohort))
    ####与IMF理想模块进行比对
    system(paste0(plink," --bfile ",cohort,' --noweb --extract snp_IMF.txt --recode --make-bed --out ',cohort1))
    system(paste0(plink," --bfile ",cohort1,' --recode A --recode-allele recodeIMF.txt --out ',cohort2))
    raw <- read.table(file = paste0(cohort2,".raw"))
    raw <- raw[-1,-c(1:6)]
    c <- length(raw[1,])
    r <- length(raw[,1])/2
    raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
    raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
    raw3 <- order(-raw2)
    raw3 <- raw3[1:5]
    raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
    raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
    raw6 <- order(-raw5)
    raw6 <- raw6[1:20] + 100
    bv_Founder <- get.bv(population,gen = index+12)
    bv_Founder[c(1,2),c(raw3,raw6)] <- 120
    bv_Founder <- t(bv_Founder)
    write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
    bv_Founder_R <- read.csv("bv_Founder.csv")
    population <- insert.bve(population,bv_Founder_R,type = "bve")
  }
  ped <- get.pedigree(population,gen=21)
  get.cohorts(population)
  get.pca(population,cohorts = c("Founder_M","FounderADG_10_M","FounderIMF_10_M"))
  
  #################################################################################################################################
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  ##          ######################################################################################################             ##
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  #################################################################################################################################
  
  ####ADG导入杂交(不缺失)
  ####ADG导入一代
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "FounderADG_10_M",
                                 selection.f.cohorts = "FounderIMF_10_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "KIcohortF1",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=22)
  
  ####ADG导入一代检验
  get.vcf(population,'pop_KIcohortF1',gen = 22)
  system(paste0(bcftools,' view -v snps pop_KIcohortF1.vcf -Oz -o pop_KIcohortF1.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_KIcohortF1.filter.vcf.gz --recode --out pop_KIcohortF1'))
  system(paste0(plink,' --vcf pop_KIcohortF1.filter.vcf.gz --make-bed --out pop_KIcohortF1'))
  ####与理想模块进行比对
  system(paste0(plink," --bfile pop_KIcohortF1 --noweb --extract snp_ADG.txt --recode --make-bed --out snp_KIcohortF1"))
  system(paste0(plink," --bfile snp_KIcohortF1 --recode A --recode-allele recodeADG.txt --out recodeKIcohortF1"))
  system(paste0(plink," --bfile pop_KIcohortF1 --noweb --extract snp_ideal.txt --recode --make-bed --out snp_KIcohort"))
  system(paste0(plink," --bfile snp_KIcohort --recode A --recode-allele recode.txt --out recodeKIcohort"))
  raw <- read.table(file = "recodeKIcohortF1.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  raw <- read.table(file = "recodeKIcohort.raw")
  raw <- raw[-1,]
  raw <- raw[,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw <- matrix(as.numeric(as.matrix(raw)),2*r,c)
  result <- raw %*% effect
  result <- result[c(raw3,raw6),]
  result1 <- result[1:5]
  result2 <- result[6:25]
  result5_mean <- mean(result1)
  result5_sd <- sd(result1)
  result5 <- cbind(result5_mean,result5_sd)
  result20_mean <- mean(result2)
  result20_sd <- sd(result2)
  result20 <- cbind(result20_mean,result20_sd)
  resultF1 <- rbind(result5,result20) 
  bv_KIcohortF <- get.bv(population,gen = 22)
  bv_KIcohortF[c(1,2),c(raw3,raw6)] <- 120
  bv_KIcohortF <- t(bv_KIcohortF)
  write.csv(x=bv_KIcohortF,file = "bv_KIcohortF.csv",row.names = TRUE)
  bv_KIcohortF_R <- read.csv("bv_KIcohortF.csv")
  population <- insert.bve(population,bv_KIcohortF_R,type = "bve")
  
  ####导入一代回交
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "FounderIMF_10_M",
                                 selection.f.cohorts = "KIcohortF1_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "KIcohortF2",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=23)
  
  ####导入回交二代检验
  get.vcf(population,'pop_KIcohortF2',gen = 23)
  system(paste0(bcftools,' view -v snps pop_KIcohortF2.vcf -Oz -o pop_KIcohortF2.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_KIcohortF2.filter.vcf.gz --recode --out pop_KIcohortF2'))
  system(paste0(plink,' --vcf pop_KIcohortF2.filter.vcf.gz --make-bed --out pop_KIcohortF2'))
  ####与理想模块进行比对
  system(paste0(plink," --bfile pop_KIcohortF2 --noweb --extract snp_ideal.txt --recode --make-bed --out snp_KIcohortF2"))
  system(paste0(plink," --bfile snp_KIcohortF2 --recode A --recode-allele recode.txt --out recodeKIcohortF2"))
  raw <- read.table(file = "recodeKIcohortF2.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  raw <- matrix(as.numeric(as.matrix(raw)),2*r,c)
  result <- raw %*% effect
  result <- result[c(raw3,raw6),]
  result1 <- result[1:5]
  result2 <- result[6:25]
  result5_mean <- mean(result1)
  result5_sd <- sd(result1)
  result5 <- cbind(result5_mean,result5_sd)
  result20_mean <- mean(result2)
  result20_sd <- sd(result2)
  result20 <- cbind(result20_mean,result20_sd)
  resultF2 <- rbind(result5,result20)
  result7 <- rbind(resultF1,resultF2)
  bv_Founder <- get.bv(population,gen = 23)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  
  ####横交一代
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "KIcohortF2_M",
                                 selection.f.cohorts = "KIcohortF2_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "KIcohortG1",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=24)
  
  ####横交一代检验
  get.vcf(population,'pop_KIcohortG1',gen = 24)
  system(paste0(bcftools,' view -v snps pop_KIcohortG1.vcf -Oz -o pop_KIcohortG1.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_KIcohortG1.filter.vcf.gz --recode --out pop_KIcohortG1'))
  system(paste0(plink,' --vcf pop_KIcohortG1.filter.vcf.gz --make-bed --out pop_KIcohortG1'))
  ####与理想模块进行比对
  system(paste0(plink," --bfile pop_KIcohortG1 --noweb --extract snp_ideal.txt --recode --make-bed --out snp_KIcohortG1"))
  system(paste0(plink," --bfile snp_KIcohortG1 --recode A --recode-allele recode.txt --out recodeKIcohortG1"))
  raw <- read.table(file = "recodeKIcohortG1.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  raw <- matrix(as.numeric(as.matrix(raw)),2*r,c)
  result <- raw %*% effect
  result <- result[c(raw3,raw6),]
  result1 <- result[1:5]
  result2 <- result[6:25]
  result5_mean <- mean(result1)
  result5_sd <- sd(result1)
  result5 <- cbind(result5_mean,result5_sd)
  result20_mean <- mean(result2)
  result20_sd <- sd(result2)
  result20 <- cbind(result20_mean,result20_sd)
  resultG1 <- rbind(result5,result20)
  result7 <- rbind(result7,resultG1)
  bv_KIcohort <- get.bv(population,gen = 24)
  bv_KIcohort[c(1,2),c(raw3,raw6)] <- 120
  bv_KIcohort <- t(bv_KIcohort)
  write.csv(x=bv_KIcohort,file = "bv_KIcohort.csv",row.names = TRUE)
  bv_KIcohort_R <- read.csv("bv_KIcohort.csv")
  population <- insert.bve(population,bv_KIcohort_R,type = "bve")
  
  for(index in 1:4){
    population <- breeding.diploid(population,breeding.size = c(100,100),
                                   selection.size=c(5,20),
                                   selection.m.cohorts = paste0("KIcohortG",index,"_M"),
                                   selection.f.cohorts = paste0("KIcohortG",index,"_F"),                                 
                                   selection.criteria='bve',
                                   name.cohort = paste0("KIcohortG",index+1),
                                   phenotyping="all",
                                   miraculix.cores=4)
    cohort <- paste0("pop_KIcohortG",index+1)
    cohort1 <- paste0("snp_KIcohortG",index+1)
    cohort2 <- paste0("recodeKIcohortG",index+1)
    get.vcf(population,cohort,gen = index+24)
    system(paste0(bcftools,' view -v snps ',paste0(cohort,".vcf")," -Oz -o ",paste0(cohort,".filter.vcf.gz")))
    system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --recode --out ',cohort))
    system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --make-bed --out ',cohort))
    ####与IMF理想模块进行比对
    system(paste0(plink," --bfile ",cohort,' --noweb --extract snp_ideal.txt --recode --make-bed --out ',cohort1))
    system(paste0(plink," --bfile ",cohort1,' --recode A --recode-allele recode.txt --out ',cohort2))
    raw <- read.table(file = paste0(cohort2,".raw"))
    raw <- raw[-1,-c(1:6)]
    c <- length(raw[1,])
    r <- length(raw[,1])/2
    raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
    raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
    raw3 <- order(-raw2)
    raw3 <- raw3[1:5]
    raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
    raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
    raw6 <- order(-raw5)
    raw6 <- raw6[1:20] + 100
    raw <- matrix(as.numeric(as.matrix(raw)),2*r,c)
    result <- raw %*% effect
    result <- result[c(raw3,raw6),]
    result1 <- result[1:5]
    result2 <- result[6:25]
    result5_mean <- mean(result1)
    result5_sd <- sd(result1)
    result5 <- cbind(result5_mean,result5_sd)
    result20_mean <- mean(result2)
    result20_sd <- sd(result2)
    result20 <- cbind(result20_mean,result20_sd)
    result <- rbind(result5,result20)
    result7 <- rbind(result7,result)
    bv_KIcohort <- get.bv(population,gen = index+24)
    bv_KIcohort[c(1,2),c(raw3,raw6)] <- 120
    bv_KIcohort <- t(bv_KIcohort)
    write.csv(x=bv_KIcohort,file = "bv_KIcohort.csv",row.names = TRUE)
    bv_KIcohort_R <- read.csv("bv_KIcohort.csv")
    population <- insert.bve(population,bv_KIcohort_R,type = "bve")
  }
  result_male <- result7[seq(1,nrow(result7),2),]
  result_female <- result7[seq(0,nrow(result7),2),]
  result7 <- rbind(result_male,result_female)
  write.csv(x=result7,file = paste0("FPresult",select,".csv"),row.names = FALSE)
  
  #################################################################################################################################
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  ##          ######################################################################################################             ##
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  #################################################################################################################################
  
  ###ADG假阳性
  QTL_effects <- get.qtl.effects(population)
  QTL_effects <- QTL_effects[[1]][[1]]
  snp_true <- sample(QTL_effects[,1],40)
  snp_false <- sample(1:30,40,replace = TRUE)
  snp_false <- snp_true+snp_false
  snp_false[snp_false > 833] <- 833
  chr <- match(snp_true,QTL_effects[,1])
  chr <- QTL_effects[chr,2]
  allele <- sample(c("A","C"),40,replace = TRUE)
  QTL_false <- data.frame(chr,snp_false,allele)
  QTL_false[,1] <- paste0('Chr',QTL_false[,1],'SNP',QTL_false[,2])
  QTL_ADG_false <- QTL_false[,c(1,3)]
  ####IMF假阳性
  QTL_effects <- get.qtl.effects(population)
  QTL_effects <- QTL_effects[[1]][[2]]
  snp_true <- sample(QTL_effects[,1],180)
  snp_false <- sample(1:50,180,replace = TRUE)
  snp_false <- snp_true+snp_false
  snp_false[snp_false > 833] <- 833
  chr <- match(snp_true,QTL_effects[,1])
  chr <- QTL_effects[chr,2]
  allele <- sample(c("A","C"),180,replace = TRUE)
  QTL_false <- data.frame(chr,snp_false,allele)
  QTL_false[,1] <- paste0('Chr',QTL_false[,1],'SNP',QTL_false[,2])
  QTL_IMF_false <- QTL_false[,c(1,3)]
  
  ####缺失30%
  recode <- read.table(file = "recode.txt")
  names(recode) <- c("chr","allele")
  recode <- rbind(recode,QTL_ADG_false)
  index <- unique(recode[,1])
  index <- index[1:630]
  index <- match(index,recode[,1])
  recode <- recode[index,]
  length(unique(recode[,1]))
  recode <- rbind(recode,QTL_IMF_false)
  index <- unique(recode[,1])
  index <- match(index,recode[,1])
  index <- index[1:780]
  recode <- recode[index,]
  write.table(x=recode[,1],file = "snp_ideal.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recode,file = "recode.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  ####ADG
  recodeADG <- read.table(file = "recodeADG.txt")
  names(recodeADG) <- c("chr","allele")
  recodeADG <- rbind(recodeADG,recode[c(601:630),])
  write.table(x=recodeADG,file = "recodeADG.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recodeADG[,1],file = "snp_ADG.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  ####IMF
  recodeIMF <- read.table(file = "recodeIMF.txt")
  names(recodeIMF) <- c("chr","allele")
  recodeIMF <- rbind(recodeIMF,recode[c(631:780),])
  write.table(x=recodeIMF[,1],file = "snp_IMF.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recodeIMF,file = "recodeIMF.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  
  ####修改杂交一代亲本育种值
  index = 9
  ####ADG群体
  cohort <- paste0("pop_FounderADG",index+1)
  cohort1 <- paste0("snp_FounderADG",index+1)
  cohort2 <- paste0("recodeADG",index+1)
  get.vcf(population,cohort,gen = index+2)
  system(paste0(bcftools,' view -v snps ',paste0(cohort,".vcf")," -Oz -o ",paste0(cohort,".filter.vcf.gz")))
  system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --recode --out ',cohort))
  system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --make-bed --out ',cohort))
  ####与ADG理想模块进行比对
  system(paste0(plink," --bfile ",cohort,' --noweb --extract snp_ADG.txt --recode --make-bed --out ',cohort1))
  system(paste0(plink," --bfile ",cohort1,' --recode A --recode-allele recodeADG.txt --out ',cohort2))
  raw <- read.table(file = paste0(cohort2,".raw"))
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  bv_Founder <- get.bv(population,gen = index+2)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  ####IMF群体
  cohort <- paste0("pop_FounderIMF",index+1)
  cohort1 <- paste0("snp_FounderIMF",index+1)
  cohort2 <- paste0("recodeIMF",index+1)
  get.vcf(population,cohort,gen = index+12)
  system(paste0(bcftools,' view -v snps ',paste0(cohort,".vcf")," -Oz -o ",paste0(cohort,".filter.vcf.gz")))
  system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --recode --out ',cohort))
  system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --make-bed --out ',cohort))
  ####与IMF理想模块进行比对
  system(paste0(plink," --bfile ",cohort,' --noweb --extract snp_IMF.txt --recode --make-bed --out ',cohort1))
  system(paste0(plink," --bfile ",cohort1,' --recode A --recode-allele recodeIMF.txt --out ',cohort2))
  raw <- read.table(file = paste0(cohort2,".raw"))
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  bv_Founder <- get.bv(population,gen = index+12)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  
  #################################################################################################################################
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  ##          ######################################################################################################             ##
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  #################################################################################################################################
  
  ####ADG导入杂交(假阳性30%)
  ####ADG导入一代
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "FounderADG_10_M",
                                 selection.f.cohorts = "FounderIMF_10_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "KI10cohortF1",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=29)
  
  ####ADG导入一代检验
  get.vcf(population,'pop_KI10cohortF1',gen = 29)
  system(paste0(bcftools,' view -v snps pop_KI10cohortF1.vcf -Oz -o pop_KI10cohortF1.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_KI10cohortF1.filter.vcf.gz --recode --out pop_KI10cohortF1'))
  system(paste0(plink,' --vcf pop_KI10cohortF1.filter.vcf.gz --make-bed --out pop_KI10cohortF1'))
  ####与理想模块进行比对
  system(paste0(plink," --bfile pop_KI10cohortF1 --noweb --extract snp_ADG.txt --recode --make-bed --out snp_KI10cohortF1"))
  system(paste0(plink," --bfile snp_KI10cohortF1 --recode A --recode-allele recodeADG.txt --out recodeKI10cohortF1"))
  system(paste0(plink," --bfile pop_KI10cohortF1 --noweb --extract snp.txt --recode --make-bed --out snp_KI10cohort"))
  system(paste0(plink," --bfile snp_KI10cohort --recode A --recode-allele recodeIDEAL.txt --out recodeKI10cohort"))
  raw <- read.table(file = "recodeKI10cohortF1.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  raw <- read.table(file = "recodeKI10cohort.raw")
  raw <- raw[-1,]
  raw <- raw[,-c(1:6)]
  raw <- matrix(as.numeric(as.matrix(raw)),200,600)
  result <- raw %*% effect
  result <- result[c(raw3,raw6),]
  result1 <- result[1:5]
  result2 <- result[6:25]
  result5_mean <- mean(result1)
  result5_sd <- sd(result1)
  result5 <- cbind(result5_mean,result5_sd)
  result20_mean <- mean(result2)
  result20_sd <- sd(result2)
  result20 <- cbind(result20_mean,result20_sd)
  resultF1 <- rbind(result5,result20) 
  bv_KI10cohortF <- get.bv(population,gen = 29)
  bv_KI10cohortF[c(1,2),c(raw3,raw6)] <- 120
  bv_KI10cohortF <- t(bv_KI10cohortF)
  write.csv(x=bv_KI10cohortF,file = "bv_KI10cohortF.csv",row.names = TRUE)
  bv_KI10cohortF_R <- read.csv("bv_KI10cohortF.csv")
  population <- insert.bve(population,bv_KI10cohortF_R,type = "bve")
  
  ####导入一代回交
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "FounderIMF_10_M",
                                 selection.f.cohorts = "KI10cohortF1_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "KI10cohortF2",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=30)
  
  ####导入回交二代检验
  get.vcf(population,'pop_KI10cohortF2',gen = 30)
  system(paste0(bcftools,' view -v snps pop_KI10cohortF2.vcf -Oz -o pop_KI10cohortF2.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_KI10cohortF2.filter.vcf.gz --recode --out pop_KI10cohortF2'))
  system(paste0(plink,' --vcf pop_KI10cohortF2.filter.vcf.gz --make-bed --out pop_KI10cohortF2'))
  ####与理想模块进行比对
  system(paste0(plink," --bfile pop_KI10cohortF2 --noweb --extract snp_ideal.txt --recode --make-bed --out snp_KI10cohortF2"))
  system(paste0(plink," --bfile snp_KI10cohortF2 --recode A --recode-allele recode.txt --out recodeKI10cohortF2"))
  system(paste0(plink," --bfile pop_KI10cohortF2 --noweb --extract snp.txt --recode --make-bed --out snp_KI10cohort"))
  system(paste0(plink," --bfile snp_KI10cohort --recode A --recode-allele recodeIDEAL.txt --out recodeKI10cohort"))
  raw <- read.table(file = "recodeKI10cohortF2.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  raw <- read.table(file = "recodeKI10cohort.raw")
  raw <- raw[-1,]
  raw <- raw[,-c(1:6)]
  raw <- matrix(as.numeric(as.matrix(raw)),200,600)
  result <- raw %*% effect
  result <- result[c(raw3,raw6),]
  result1 <- result[1:5]
  result2 <- result[6:25]
  result5_mean <- mean(result1)
  result5_sd <- sd(result1)
  result5 <- cbind(result5_mean,result5_sd)
  result20_mean <- mean(result2)
  result20_sd <- sd(result2)
  result20 <- cbind(result20_mean,result20_sd)
  resultF2 <- rbind(result5,result20)
  result7 <- rbind(resultF1,resultF2)
  bv_Founder <- get.bv(population,gen = 30)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  
  ####横交一代
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "KI10cohortF2_M",
                                 selection.f.cohorts = "KI10cohortF2_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "KI10cohortG1",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=31)
  
  ####横交一代检验
  get.vcf(population,'pop_KI10cohortG1',gen = 31)
  system(paste0(bcftools,' view -v snps pop_KI10cohortG1.vcf -Oz -o pop_KI10cohortG1.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_KI10cohortG1.filter.vcf.gz --recode --out pop_KI10cohortG1'))
  system(paste0(plink,' --vcf pop_KI10cohortG1.filter.vcf.gz --make-bed --out pop_KI10cohortG1'))
  ####与理想模块进行比对
  system(paste0(plink," --bfile pop_KI10cohortG1 --noweb --extract snp_ideal.txt --recode --make-bed --out snp_KI10cohortG1"))
  system(paste0(plink," --bfile snp_KI10cohortG1 --recode A --recode-allele recode.txt --out recodeKI10cohortG1"))
  system(paste0(plink," --bfile pop_KI10cohortG1 --noweb --extract snp.txt --recode --make-bed --out snp_KI10cohort"))
  system(paste0(plink," --bfile snp_KI10cohort --recode A --recode-allele recodeIDEAL.txt --out recodeKI10cohort"))
  raw <- read.table(file = "recodeKI10cohortG1.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  raw <- read.table(file = "recodeKI10cohort.raw")
  raw <- raw[-1,]
  raw <- raw[,-c(1:6)]
  raw <- matrix(as.numeric(as.matrix(raw)),200,600)
  result <- raw %*% effect
  result <- result[c(raw3,raw6),]
  result1 <- result[1:5]
  result2 <- result[6:25]
  result5_mean <- mean(result1)
  result5_sd <- sd(result1)
  result5 <- cbind(result5_mean,result5_sd)
  result20_mean <- mean(result2)
  result20_sd <- sd(result2)
  result20 <- cbind(result20_mean,result20_sd)
  resultG1 <- rbind(result5,result20)
  result7 <- rbind(result7,resultG1)
  bv_KI10cohort <- get.bv(population,gen = 31)
  bv_KI10cohort[c(1,2),c(raw3,raw6)] <- 120
  bv_KI10cohort <- t(bv_KI10cohort)
  write.csv(x=bv_KI10cohort,file = "bv_KI10cohort.csv",row.names = TRUE)
  bv_KI10cohort_R <- read.csv("bv_KI10cohort.csv")
  population <- insert.bve(population,bv_KI10cohort_R,type = "bve")
  ####横交四代
  for(index in 1:4){
    population <- breeding.diploid(population,breeding.size = c(100,100),
                                   selection.size=c(5,20),
                                   selection.m.cohorts = paste0("KI10cohortG",index,"_M"),
                                   selection.f.cohorts = paste0("KI10cohortG",index,"_F"),                                 
                                   selection.criteria='bve',
                                   name.cohort = paste0("KI10cohortG",index+1),
                                   phenotyping="all",
                                   miraculix.cores=4)
    cohort <- paste0("pop_KI10cohortG",index+1)
    cohort1 <- paste0("snp_KI10cohortG",index+1)
    cohort2 <- paste0("recodeKI10cohortG",index+1)
    get.vcf(population,cohort,gen = index+31)
    system(paste0(bcftools,' view -v snps ',paste0(cohort,".vcf")," -Oz -o ",paste0(cohort,".filter.vcf.gz")))
    system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --recode --out ',cohort))
    system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --make-bed --out ',cohort))
    ####与IMF理想模块进行比对
    system(paste0(plink," --bfile ",cohort,' --noweb --extract snp_ideal.txt --recode --make-bed --out ',cohort1))
    system(paste0(plink," --bfile ",cohort1,' --recode A --recode-allele recode.txt --out ',cohort2))
    system(paste0(plink," --bfile ",cohort,' --noweb --extract snp.txt --recode --make-bed --out snp_KI10cohort'))
    system(paste0(plink," --bfile snp_KI10cohort --recode A --recode-allele recodeIDEAL.txt --out recodeKI10cohort"))
    raw <- read.table(file = paste0(cohort2,".raw"))
    raw <- raw[-1,-c(1:6)]
    c <- length(raw[1,])
    r <- length(raw[,1])/2
    raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
    raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
    raw3 <- order(-raw2)
    raw3 <- raw3[1:5]
    raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
    raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
    raw6 <- order(-raw5)
    raw6 <- raw6[1:20] + 100
    raw <- read.table(file = "recodeKI10cohort.raw")
    raw <- raw[-1,]
    raw <- raw[,-c(1:6)]
    raw <- matrix(as.numeric(as.matrix(raw)),200,600)
    result <- raw %*% effect
    result <- result[c(raw3,raw6),]
    result1 <- result[1:5]
    result2 <- result[6:25]
    result5_mean <- mean(result1)
    result5_sd <- sd(result1)
    result5 <- cbind(result5_mean,result5_sd)
    result20_mean <- mean(result2)
    result20_sd <- sd(result2)
    result20 <- cbind(result20_mean,result20_sd)
    result <- rbind(result5,result20)
    result7 <- rbind(result7,result)
    bv_KI10cohort <- get.bv(population,gen = index+31)
    bv_KI10cohort[c(1,2),c(raw3,raw6)] <- 120
    bv_KI10cohort <- t(bv_KI10cohort)
    write.csv(x=bv_KI10cohort,file = "bv_KI10cohort.csv",row.names = TRUE)
    bv_KI10cohort_R <- read.csv("bv_KI10cohort.csv")
    population <- insert.bve(population,bv_KI10cohort_R,type = "bve")
  }
  result_male <- result7[seq(1,nrow(result7),2),]
  result_female <- result7[seq(0,nrow(result7),2),]
  result7 <- rbind(result_male,result_female)
  write.csv(x=result7,file = paste0("FP30result",select,".csv"),row.names = FALSE)
  
  #################################################################################################################################
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  ##          ######################################################################################################             ##
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  #################################################################################################################################
  
  ####缺失20%
  
  write.table(x=recodeADG[1:120,1],file = "snp_ADG.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recodeADG[1:120,],file = "recodeADG.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recodeIMF[1:600,1],file = "snp_IMF.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recodeIMF[1:600,],file = "recodeIMF.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  recode20 <- rbind(recodeADG[1:120,],recodeIMF[1:600,])
  write.table(x=recode20,file = "snp_ideal.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recode20,file = "recode.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  ####修改杂交一代亲本育种值
  index = 9
  ####ADG群体
  cohort <- paste0("pop_FounderADG",index+1)
  cohort1 <- paste0("snp_FounderADG",index+1)
  cohort2 <- paste0("recodeADG",index+1)
  get.vcf(population,cohort,gen = index+2)
  system(paste0(bcftools,' view -v snps ',paste0(cohort,".vcf")," -Oz -o ",paste0(cohort,".filter.vcf.gz")))
  system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --recode --out ',cohort))
  system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --make-bed --out ',cohort))
  ####与ADG理想模块进行比对
  system(paste0(plink," --bfile ",cohort,' --noweb --extract snp_ADG.txt --recode --make-bed --out ',cohort1))
  system(paste0(plink," --bfile ",cohort1,' --recode A --recode-allele recodeADG.txt --out ',cohort2))
  raw <- read.table(file = paste0(cohort2,".raw"))
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  bv_Founder <- get.bv(population,gen = index+2)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  ####IMF群体
  cohort <- paste0("pop_FounderIMF",index+1)
  cohort1 <- paste0("snp_FounderIMF",index+1)
  cohort2 <- paste0("recodeIMF",index+1)
  get.vcf(population,cohort,gen = index+12)
  system(paste0(bcftools,' view -v snps ',paste0(cohort,".vcf")," -Oz -o ",paste0(cohort,".filter.vcf.gz")))
  system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --recode --out ',cohort))
  system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --make-bed --out ',cohort))
  ####与IMF理想模块进行比对
  system(paste0(plink," --bfile ",cohort,' --noweb --extract snp_IMF.txt --recode --make-bed --out ',cohort1))
  system(paste0(plink," --bfile ",cohort1,' --recode A --recode-allele recodeIMF.txt --out ',cohort2))
  raw <- read.table(file = paste0(cohort2,".raw"))
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  bv_Founder <- get.bv(population,gen = index+12)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  
  #################################################################################################################################
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  ##          ######################################################################################################             ##
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  #################################################################################################################################
  
  ####ADG导入杂交(假阳性20%)
  ####ADG导入一代
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "FounderADG_10_M",
                                 selection.f.cohorts = "FounderIMF_10_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "KI20cohortF1",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=36)
  
  ####ADG导入一代检验
  get.vcf(population,'pop_KI20cohortF1',gen = 36)
  system(paste0(bcftools,' view -v snps pop_KI20cohortF1.vcf -Oz -o pop_KI20cohortF1.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_KI20cohortF1.filter.vcf.gz --recode --out pop_KI20cohortF1'))
  system(paste0(plink,' --vcf pop_KI20cohortF1.filter.vcf.gz --make-bed --out pop_KI20cohortF1'))
  ####与理想模块进行比对
  system(paste0(plink," --bfile pop_KI20cohortF1 --noweb --extract snp_ADG.txt --recode --make-bed --out snp_KI20cohortF1"))
  system(paste0(plink," --bfile snp_KI20cohortF1 --recode A --recode-allele recodeADG.txt --out recodeKI20cohortF1"))
  system(paste0(plink," --bfile pop_KI20cohortF1 --noweb --extract snp.txt --recode --make-bed --out snp_KI20cohort"))
  system(paste0(plink," --bfile snp_KI20cohort --recode A --recode-allele recodeIDEAL.txt --out recodeKI20cohort"))
  raw <- read.table(file = "recodeKI20cohortF1.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  raw <- read.table(file = "recodeKI20cohort.raw")
  raw <- raw[-1,]
  raw <- raw[,-c(1:6)]
  raw <- matrix(as.numeric(as.matrix(raw)),200,600)
  result <- raw %*% effect
  result <- result[c(raw3,raw6),]
  result1 <- result[1:5]
  result2 <- result[6:25]
  result5_mean <- mean(result1)
  result5_sd <- sd(result1)
  result5 <- cbind(result5_mean,result5_sd)
  result20_mean <- mean(result2)
  result20_sd <- sd(result2)
  result20 <- cbind(result20_mean,result20_sd)
  resultF1 <- rbind(result5,result20) 
  bv_KI20cohortF <- get.bv(population,gen = 36)
  bv_KI20cohortF[c(1,2),c(raw3,raw6)] <- 120
  bv_KI20cohortF <- t(bv_KI20cohortF)
  write.csv(x=bv_KI20cohortF,file = "bv_KI20cohortF.csv",row.names = TRUE)
  bv_KI20cohortF_R <- read.csv("bv_KI20cohortF.csv")
  population <- insert.bve(population,bv_KI20cohortF_R,type = "bve")
  
  ####导入一代回交
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "FounderIMF_10_M",
                                 selection.f.cohorts = "KI20cohortF1_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "KI20cohortF2",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=37)
  
  ####导入回交二代检验
  get.vcf(population,'pop_KI20cohortF2',gen = 37)
  system(paste0(bcftools,' view -v snps pop_KI20cohortF2.vcf -Oz -o pop_KI20cohortF2.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_KI20cohortF2.filter.vcf.gz --recode --out pop_KI20cohortF2'))
  system(paste0(plink,' --vcf pop_KI20cohortF2.filter.vcf.gz --make-bed --out pop_KI20cohortF2'))
  ####与理想模块进行比对
  system(paste0(plink," --bfile pop_KI20cohortF2 --noweb --extract snp_ideal.txt --recode --make-bed --out snp_KI20cohortF2"))
  system(paste0(plink," --bfile snp_KI20cohortF2 --recode A --recode-allele recode.txt --out recodeKI20cohortF2"))
  raw <- read.table(file = "recodeKI20cohortF2.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  system(paste0(plink," --bfile pop_KI20cohortF2 --noweb --extract snp.txt --recode --make-bed --out snp_KI20cohort"))
  system(paste0(plink," --bfile snp_KI20cohort --recode A --recode-allele recodeIDEAL.txt --out recodeKI20cohort"))
  raw <- read.table(file = "recodeKI20cohort.raw")
  raw <- raw[-1,]
  raw <- raw[,-c(1:6)]
  raw <- matrix(as.numeric(as.matrix(raw)),200,600)
  result <- raw %*% effect
  result <- result[c(raw3,raw6),]
  result1 <- result[1:5]
  result2 <- result[6:25]
  result5_mean <- mean(result1)
  result5_sd <- sd(result1)
  result5 <- cbind(result5_mean,result5_sd)
  result20_mean <- mean(result2)
  result20_sd <- sd(result2)
  result20 <- cbind(result20_mean,result20_sd)
  resultF2 <- rbind(result5,result20)
  result7 <- rbind(resultF1,resultF2)
  bv_Founder <- get.bv(population,gen = 37)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  
  ####横交一代
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "KI20cohortF2_M",
                                 selection.f.cohorts = "KI20cohortF2_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "KI20cohortG1",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=38)
  
  ####横交一代检验
  get.vcf(population,'pop_KI20cohortG1',gen = 38)
  system(paste0(bcftools,' view -v snps pop_KI20cohortG1.vcf -Oz -o pop_KI20cohortG1.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_KI20cohortG1.filter.vcf.gz --recode --out pop_KI20cohortG1'))
  system(paste0(plink,' --vcf pop_KI20cohortG1.filter.vcf.gz --make-bed --out pop_KI20cohortG1'))
  ####与理想模块进行比对
  system(paste0(plink," --bfile pop_KI20cohortG1 --noweb --extract snp_ideal.txt --recode --make-bed --out snp_KI20cohortG1"))
  system(paste0(plink," --bfile snp_KI20cohortG1 --recode A --recode-allele recode.txt --out recodeKI20cohortG1"))
  raw <- read.table(file = "recodeKI20cohortG1.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  system(paste0(plink," --bfile pop_KI20cohortG1 --noweb --extract snp.txt --recode --make-bed --out snp_KI20cohort"))
  system(paste0(plink," --bfile snp_KI20cohort --recode A --recode-allele recodeIDEAL.txt --out recodeKI20cohort"))
  raw <- read.table(file = "recodeKI20cohort.raw")
  raw <- raw[-1,]
  raw <- raw[,-c(1:6)]
  raw <- matrix(as.numeric(as.matrix(raw)),200,600)
  result <- raw %*% effect
  result <- result[c(raw3,raw6),]
  result1 <- result[1:5]
  result2 <- result[6:25]
  result5_mean <- mean(result1)
  result5_sd <- sd(result1)
  result5 <- cbind(result5_mean,result5_sd)
  result20_mean <- mean(result2)
  result20_sd <- sd(result2)
  result20 <- cbind(result20_mean,result20_sd)
  resultG1 <- rbind(result5,result20)
  result7 <- rbind(result7,resultG1)
  bv_KI20cohort <- get.bv(population,gen = 38)
  bv_KI20cohort[c(1,2),c(raw3,raw6)] <- 120
  bv_KI20cohort <- t(bv_KI20cohort)
  write.csv(x=bv_KI20cohort,file = "bv_KI20cohort.csv",row.names = TRUE)
  bv_KI20cohort_R <- read.csv("bv_KI20cohort.csv")
  population <- insert.bve(population,bv_KI20cohort_R,type = "bve")
  ####横交固定四代
  for(index in 1:4){
    population <- breeding.diploid(population,breeding.size = c(100,100),
                                   selection.size=c(5,20),
                                   selection.m.cohorts = paste0("KI20cohortG",index,"_M"),
                                   selection.f.cohorts = paste0("KI20cohortG",index,"_F"),                                 
                                   selection.criteria='bve',
                                   name.cohort = paste0("KI20cohortG",index+1),
                                   phenotyping="all",
                                   miraculix.cores=4)
    cohort <- paste0("pop_KI20cohortG",index+1)
    cohort1 <- paste0("snp_KI20cohortG",index+1)
    cohort2 <- paste0("recodeKI20cohortG",index+1)
    get.vcf(population,cohort,gen = index+38)
    system(paste0(bcftools,' view -v snps ',paste0(cohort,".vcf")," -Oz -o ",paste0(cohort,".filter.vcf.gz")))
    system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --recode --out ',cohort))
    system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --make-bed --out ',cohort))
    ####与IMF理想模块进行比对
    system(paste0(plink," --bfile ",cohort,' --noweb --extract snp_ideal.txt --recode --make-bed --out ',cohort1))
    system(paste0(plink," --bfile ",cohort1,' --recode A --recode-allele recode.txt --out ',cohort2))
    raw <- read.table(file = paste0(cohort2,".raw"))
    raw <- raw[-1,-c(1:6)]
    c <- length(raw[1,])
    r <- length(raw[,1])/2
    raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
    raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
    raw3 <- order(-raw2)
    raw3 <- raw3[1:5]
    raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
    raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
    raw6 <- order(-raw5)
    raw6 <- raw6[1:20] + 100
    system(paste0(plink," --bfile ",cohort,' --noweb --extract snp.txt --recode --make-bed --out snp_KI20cohort'))
    system(paste0(plink," --bfile snp_KI20cohort --recode A --recode-allele recodeIDEAL.txt --out recodeKI20cohort"))
    raw <- read.table(file = "recodeKI20cohort.raw")
    raw <- raw[-1,]
    raw <- raw[,-c(1:6)]
    raw <- matrix(as.numeric(as.matrix(raw)),200,600)
    result <- raw %*% effect
    result <- result[c(raw3,raw6),]
    result1 <- result[1:5]
    result2 <- result[6:25]
    result5_mean <- mean(result1)
    result5_sd <- sd(result1)
    result5 <- cbind(result5_mean,result5_sd)
    result20_mean <- mean(result2)
    result20_sd <- sd(result2)
    result20 <- cbind(result20_mean,result20_sd)
    result <- rbind(result5,result20)
    result7 <- rbind(result7,result)
    bv_KI20cohort <- get.bv(population,gen = index+38)
    bv_KI20cohort[c(1,2),c(raw3,raw6)] <- 120
    bv_KI20cohort <- t(bv_KI20cohort)
    write.csv(x=bv_KI20cohort,file = "bv_KI20cohort.csv",row.names = TRUE)
    bv_KI20cohort_R <- read.csv("bv_KI20cohort.csv")
    population <- insert.bve(population,bv_KI20cohort_R,type = "bve")
  }
  result_male <- result7[seq(1,nrow(result7),2),]
  result_female <- result7[seq(0,nrow(result7),2),]
  result7 <- rbind(result_male,result_female)
  write.csv(x=result7,file = paste0("FP20result",select,".csv"),row.names = FALSE)
  
  #################################################################################################################################
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  ##          ######################################################################################################             ##
  ##                                                                                                                             ##
  ##                                                                                                                             ##
  #################################################################################################################################
  
  ####假阳性10%
  write.table(x=recodeADG[1:110,1],file = "snp_ADG.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recodeADG[1:110,],file = "recodeADG.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recodeIMF[1:550,1],file = "snp_IMF.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recodeIMF[1:550,],file = "recodeIMF.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  recode20 <- rbind(recodeADG[1:110,],recodeIMF[1:550,])
  write.table(x=recode20,file = "snp_ideal.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  write.table(x=recode20,file = "recode.txt",row.names = FALSE,col.names = FALSE,quote = FALSE)
  ####修改杂交一代亲本育种值
  
  ####修改杂交一代亲本育种值
  index = 9
  ####ADG群体
  cohort <- paste0("pop_FounderADG",index+1)
  cohort1 <- paste0("snp_FounderADG",index+1)
  cohort2 <- paste0("recodeADG",index+1)
  get.vcf(population,cohort,gen = index+2)
  system(paste0(bcftools,' view -v snps ',paste0(cohort,".vcf")," -Oz -o ",paste0(cohort,".filter.vcf.gz")))
  system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --recode --out ',cohort))
  system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --make-bed --out ',cohort))
  ####与ADG理想模块进行比对
  system(paste0(plink," --bfile ",cohort,' --noweb --extract snp_ADG.txt --recode --make-bed --out ',cohort1))
  system(paste0(plink," --bfile ",cohort1,' --recode A --recode-allele recodeADG.txt --out ',cohort2))
  raw <- read.table(file = paste0(cohort2,".raw"))
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  bv_Founder <- get.bv(population,gen = index+2)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  ####IMF群体
  cohort <- paste0("pop_FounderIMF",index+1)
  cohort1 <- paste0("snp_FounderIMF",index+1)
  cohort2 <- paste0("recodeIMF",index+1)
  get.vcf(population,cohort,gen = index+12)
  system(paste0(bcftools,' view -v snps ',paste0(cohort,".vcf")," -Oz -o ",paste0(cohort,".filter.vcf.gz")))
  system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --recode --out ',cohort))
  system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --make-bed --out ',cohort))
  ####与IMF理想模块进行比对
  system(paste0(plink," --bfile ",cohort,' --noweb --extract snp_IMF.txt --recode --make-bed --out ',cohort1))
  system(paste0(plink," --bfile ",cohort1,' --recode A --recode-allele recodeIMF.txt --out ',cohort2))
  raw <- read.table(file = paste0(cohort2,".raw"))
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  bv_Founder <- get.bv(population,gen = index+12)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  
  ####ADG导入杂交(假阳性10%)
  ####ADG导入一代
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "FounderADG_10_M",
                                 selection.f.cohorts = "FounderIMF_10_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "KI30cohortF1",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=43)
  
  ####ADG导入一代检验
  get.vcf(population,'pop_KI30cohortF1',gen = 43)
  system(paste0(bcftools,' view -v snps pop_KI30cohortF1.vcf -Oz -o pop_KI30cohortF1.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_KI30cohortF1.filter.vcf.gz --recode --out pop_KI30cohortF1'))
  system(paste0(plink,' --vcf pop_KI30cohortF1.filter.vcf.gz --make-bed --out pop_KI30cohortF1'))
  ####与理想模块进行比对
  system(paste0(plink," --bfile pop_KI30cohortF1 --noweb --extract snp_ADG.txt --recode --make-bed --out snp_KI30cohortF1"))
  system(paste0(plink," --bfile snp_KI30cohortF1 --recode A --recode-allele recodeADG.txt --out recodeKI30cohortF1"))
  raw <- read.table(file = "recodeKI30cohortF1.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  system(paste0(plink," --bfile pop_KI30cohortF1 --noweb --extract snp.txt --recode --make-bed --out snp_KI30cohort"))
  system(paste0(plink," --bfile snp_KI30cohort --recode A --recode-allele recodeIDEAL.txt --out recodeKI30cohort"))
  raw <- read.table(file = "recodeKI30cohort.raw")
  raw <- raw[-1,]
  raw <- raw[,-c(1:6)]
  raw <- matrix(as.numeric(as.matrix(raw)),200,600)
  result <- raw %*% effect
  result <- result[c(raw3,raw6),]
  result1 <- result[1:5]
  result2 <- result[6:25]
  result5_mean <- mean(result1)
  result5_sd <- sd(result1)
  result5 <- cbind(result5_mean,result5_sd)
  result20_mean <- mean(result2)
  result20_sd <- sd(result2)
  result20 <- cbind(result20_mean,result20_sd)
  resultF1 <- rbind(result5,result20) 
  bv_KI30cohortF <- get.bv(population,gen = 43)
  bv_KI30cohortF[c(1,2),c(raw3,raw6)] <- 120
  bv_KI30cohortF <- t(bv_KI30cohortF)
  write.csv(x=bv_KI30cohortF,file = "bv_KI30cohortF.csv",row.names = TRUE)
  bv_KI30cohortF_R <- read.csv("bv_KI30cohortF.csv")
  population <- insert.bve(population,bv_KI30cohortF_R,type = "bve")
  
  ####导入一代回交
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "FounderIMF_10_M",
                                 selection.f.cohorts = "KI30cohortF1_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "KI30cohortF2",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=44)
  
  ####导入回交二代检验
  get.vcf(population,'pop_KI30cohortF2',gen = 44)
  system(paste0(bcftools,' view -v snps pop_KI30cohortF2.vcf -Oz -o pop_KI30cohortF2.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_KI30cohortF2.filter.vcf.gz --recode --out pop_KI30cohortF2'))
  system(paste0(plink,' --vcf pop_KI30cohortF2.filter.vcf.gz --make-bed --out pop_KI30cohortF2'))
  ####与理想模块进行比对
  system(paste0(plink," --bfile pop_KI30cohortF2 --noweb --extract snp_ideal.txt --recode --make-bed --out snp_KI30cohortF2"))
  system(paste0(plink," --bfile snp_KI30cohortF2 --recode A --recode-allele recode.txt --out recodeKI30cohortF2"))
  raw <- read.table(file = "recodeKI30cohortF2.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  system(paste0(plink," --bfile pop_KI30cohortF2 --noweb --extract snp.txt --recode --make-bed --out snp_KI30cohort"))
  system(paste0(plink," --bfile snp_KI30cohort --recode A --recode-allele recodeIDEAL.txt --out recodeKI30cohort"))
  raw <- read.table(file = "recodeKI30cohort.raw")
  raw <- raw[-1,]
  raw <- raw[,-c(1:6)]
  raw <- matrix(as.numeric(as.matrix(raw)),200,600)
  result <- raw %*% effect
  result <- result[c(raw3,raw6),]
  result1 <- result[1:5]
  result2 <- result[6:25]
  result5_mean <- mean(result1)
  result5_sd <- sd(result1)
  result5 <- cbind(result5_mean,result5_sd)
  result20_mean <- mean(result2)
  result20_sd <- sd(result2)
  result20 <- cbind(result20_mean,result20_sd)
  resultF2 <- rbind(result5,result20)
  result7 <- rbind(resultF1,resultF2)
  bv_Founder <- get.bv(population,gen = 44)
  bv_Founder[c(1,2),c(raw3,raw6)] <- 120
  bv_Founder <- t(bv_Founder)
  write.csv(x=bv_Founder,file = "bv_Founder.csv",row.names = TRUE)
  bv_Founder_R <- read.csv("bv_Founder.csv")
  population <- insert.bve(population,bv_Founder_R,type = "bve")
  
  ####横交一代
  population <- breeding.diploid(population,breeding.size = c(100,100),
                                 selection.size=c(5,20),
                                 selection.m.cohorts = "KI30cohortF2_M",
                                 selection.f.cohorts = "KI30cohortF2_F",
                                 selection.criteria='bve',
                                 phenotyping="all",
                                 name.cohort = "KI30cohortG1",
                                 miraculix.cores=4)
  ped <- get.pedigree(population,gen=45)
  
  ####横交一代检验
  get.vcf(population,'pop_KI30cohortG1',gen = 45)
  system(paste0(bcftools,' view -v snps pop_KI30cohortG1.vcf -Oz -o pop_KI30cohortG1.filter.vcf.gz'))
  system(paste0(plink,' --vcf pop_KI30cohortG1.filter.vcf.gz --recode --out pop_KI30cohortG1'))
  system(paste0(plink,' --vcf pop_KI30cohortG1.filter.vcf.gz --make-bed --out pop_KI30cohortG1'))
  ####与理想模块进行比对
  system(paste0(plink," --bfile pop_KI30cohortG1 --noweb --extract snp_ideal.txt --recode --make-bed --out snp_KI30cohortG1"))
  system(paste0(plink," --bfile snp_KI30cohortG1 --recode A --recode-allele recode.txt --out recodeKI30cohortG1"))
  raw <- read.table(file = "recodeKI30cohortG1.raw")
  raw <- raw[-1,-c(1:6)]
  c <- length(raw[1,])
  r <- length(raw[,1])/2
  raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
  raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
  raw3 <- order(-raw2)
  raw3 <- raw3[1:5]
  raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
  raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
  raw6 <- order(-raw5)
  raw6 <- raw6[1:20] + 100
  system(paste0(plink," --bfile pop_KI30cohortG1 --noweb --extract snp.txt --recode --make-bed --out snp_KI30cohort"))
  system(paste0(plink," --bfile snp_KI30cohort --recode A --recode-allele recodeIDEAL.txt --out recodeKI30cohort"))
  raw <- read.table(file = "recodeKI30cohort.raw")
  raw <- raw[-1,]
  raw <- raw[,-c(1:6)]
  raw <- matrix(as.numeric(as.matrix(raw)),200,600)
  result <- raw %*% effect
  result <- result[c(raw3,raw6),]
  result1 <- result[1:5]
  result2 <- result[6:25]
  result5_mean <- mean(result1)
  result5_sd <- sd(result1)
  result5 <- cbind(result5_mean,result5_sd)
  result20_mean <- mean(result2)
  result20_sd <- sd(result2)
  result20 <- cbind(result20_mean,result20_sd)
  resultG1 <- rbind(result5,result20)
  result7 <- rbind(result7,resultG1)
  bv_KI30cohort <- get.bv(population,gen = 45)
  bv_KI30cohort[c(1,2),c(raw3,raw6)] <- 120
  bv_KI30cohort <- t(bv_KI30cohort)
  write.csv(x=bv_KI30cohort,file = "bv_KI30cohort.csv",row.names = TRUE)
  bv_KI30cohort_R <- read.csv("bv_KI30cohort.csv")
  population <- insert.bve(population,bv_KI30cohort_R,type = "bve")
  
  for(index in 1:4){
    population <- breeding.diploid(population,breeding.size = c(100,100),
                                   selection.size=c(5,20),
                                   selection.m.cohorts = paste0("KI30cohortG",index,"_M"),
                                   selection.f.cohorts = paste0("KI30cohortG",index,"_F"),                                 
                                   selection.criteria='bve',
                                   name.cohort = paste0("KI30cohortG",index+1),
                                   phenotyping="all",
                                   miraculix.cores=4)
    cohort <- paste0("pop_KI30cohortG",index+1)
    cohort1 <- paste0("snp_KI30cohortG",index+1)
    cohort2 <- paste0("recodeKI30cohortG",index+1)
    get.vcf(population,cohort,gen = index+45)
    system(paste0(bcftools,' view -v snps ',paste0(cohort,".vcf")," -Oz -o ",paste0(cohort,".filter.vcf.gz")))
    system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --recode --out ',cohort))
    system(paste0(plink,' --vcf ',paste0(cohort,".filter.vcf.gz"),' --make-bed --out ',cohort))
    ####与IMF理想模块进行比对
    system(paste0(plink," --bfile ",cohort,' --noweb --extract snp_ideal.txt --recode --make-bed --out ',cohort1))
    system(paste0(plink," --bfile ",cohort1,' --recode A --recode-allele recode.txt --out ',cohort2))
    raw <- read.table(file = paste0(cohort2,".raw"))
    raw <- raw[-1,-c(1:6)]
    c <- length(raw[1,])
    r <- length(raw[,1])/2
    raw1 <- matrix(as.numeric(as.matrix(raw[c(1:100),])),r,c)
    raw2 <- apply(raw1,MARGIN = 1,FUN = sum)
    raw3 <- order(-raw2)
    raw3 <- raw3[1:5]
    raw4 <- matrix(as.numeric(as.matrix(raw[c(101:200),])),r,c)
    raw5 <- apply(raw4,MARGIN = 1,FUN = sum)
    raw6 <- order(-raw5)
    raw6 <- raw6[1:20] + 100
    system(paste0(plink," --bfile ",cohort,' --noweb --extract snp.txt --recode --make-bed --out snp_KI30cohort'))
    system(paste0(plink," --bfile snp_KI30cohort --recode A --recode-allele recodeIDEAL.txt --out recodeKI30cohort"))
    raw <- read.table(file = "recodeKI30cohort.raw")
    raw <- raw[-1,]
    raw <- raw[,-c(1:6)]
    raw <- matrix(as.numeric(as.matrix(raw)),200,600)
    result <- raw %*% effect
    result <- result[c(raw3,raw6),]
    result1 <- result[1:5]
    result2 <- result[6:25]
    result5_mean <- mean(result1)
    result5_sd <- sd(result1)
    result5 <- cbind(result5_mean,result5_sd)
    result20_mean <- mean(result2)
    result20_sd <- sd(result2)
    result20 <- cbind(result20_mean,result20_sd)
    result <- rbind(result5,result20)
    result7 <- rbind(result7,result)
    bv_KI30cohort <- get.bv(population,gen = index+45)
    bv_KI30cohort[c(1,2),c(raw3,raw6)] <- 120
    bv_KI30cohort <- t(bv_KI30cohort)
    write.csv(x=bv_KI30cohort,file = "bv_KI30cohort.csv",row.names = TRUE)
    bv_KI30cohort_R <- read.csv("bv_KI30cohort.csv")
    population <- insert.bve(population,bv_KI30cohort_R,type = "bve")
  }
  result_male <- result7[seq(1,nrow(result7),2),]
  result_female <- result7[seq(0,nrow(result7),2),]
  result7 <- rbind(result_male,result_female)
  write.csv(x=result7,file = paste0("FP10result",select,".csv"),row.names = FALSE)
  rm(list = ls())
  cat("\014")
}
